/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.diet.common.util;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.illusivesoulworks.diet.DietConstants;
import com.illusivesoulworks.diet.api.type.IDietGroup;
import com.illusivesoulworks.diet.common.config.DietConfig;
import com.illusivesoulworks.diet.common.data.group.DietGroups;
import com.illusivesoulworks.diet.platform.Services;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class DietValueGenerator {
    private static final Map<Item, Set<IDietGroup>> GENERATED = new HashMap<Item, Set<IDietGroup>>();
    private static final Map<Item, List<Item>> TRAILS = new HashMap<Item, List<Item>>();
    private static final Comparator<ItemStack> COMPARATOR = new IngredientComparator();
    private static final Set<Item> UNGROUPED = new HashSet<Item>();
    private static final Map<Item, List<Recipe<?>>> RECIPES = new HashMap();
    private static final Set<Item> PROCESSED = new HashSet<Item>();

    public static void reload(MinecraftServer server) {
        GENERATED.clear();
        TRAILS.clear();
        if (((Boolean)DietConfig.SERVER.generateGroupsForEmptyItems.get()).booleanValue()) {
            DietConstants.LOG.info("Generating diet values...");
            Stopwatch stopwatch = Stopwatch.createUnstarted();
            stopwatch.reset();
            stopwatch.start();
            Set<IDietGroup> groups = DietGroups.getGroups((Level)server.m_129783_());
            DietValueGenerator.findUngroupedFoods(groups);
            RecipeManager recipeManager = server.m_129894_();
            DietValueGenerator.findAllRecipesForItems(recipeManager);
            DietValueGenerator.processItems(groups);
            stopwatch.stop();
            DietConstants.LOG.info("Generating diet values took {}", (Object)stopwatch);
        }
    }

    private static void processItems(Set<IDietGroup> groups) {
        DietConstants.LOG.info("Processing items...");
        PROCESSED.clear();
        for (Item item : UNGROUPED) {
            if (PROCESSED.contains(item)) continue;
            ArrayList<Item> trail = new ArrayList<Item>();
            DietValueGenerator.findGroups(groups, item, trail);
        }
        DietConstants.LOG.info("Processed {} items", (Object)PROCESSED.size());
    }

    private static Set<IDietGroup> findGroups(Set<IDietGroup> groups, Item targetItem, List<Item> trail) {
        List<Recipe<?>> list;
        PROCESSED.add(targetItem);
        HashSet<IDietGroup> result = new HashSet<IDietGroup>();
        ItemStack proxy = new ItemStack((ItemLike)targetItem);
        for (IDietGroup group : groups) {
            if (!group.contains(proxy)) continue;
            result.add(group);
        }
        if (result.isEmpty() && (list = RECIPES.get(targetItem)) != null) {
            HashSet<IDietGroup> found = new HashSet<IDietGroup>();
            for (Recipe<?> recipe : list) {
                HashSet<Item> keys = new HashSet<Item>();
                block2: for (Ingredient ingredient : recipe.m_7527_()) {
                    ItemStack[] itemStacks = (ItemStack[])ingredient.m_43908_().clone();
                    if (itemStacks.length == 0) continue;
                    Arrays.sort(itemStacks, COMPARATOR);
                    for (int i = 0; i < itemStacks.length; ++i) {
                        ArrayList<Item> subTrail;
                        ItemStack stack = itemStacks[i];
                        Item item = stack.m_41720_();
                        if (i == 0) {
                            if (keys.contains(item)) continue block2;
                            keys.add(item);
                        }
                        if (Services.REGISTRY.isIngredient(stack)) continue;
                        Set<IDietGroup> fallback = GENERATED.get(item);
                        boolean addTrail = false;
                        if (fallback != null) {
                            found.addAll(fallback);
                            addTrail = !fallback.isEmpty();
                        } else if (!PROCESSED.contains(item)) {
                            subTrail = new ArrayList();
                            HashSet<IDietGroup> pending = new HashSet<IDietGroup>(DietValueGenerator.findGroups(groups, item, subTrail));
                            found.addAll(pending);
                            GENERATED.putIfAbsent(item, pending);
                            TRAILS.putIfAbsent(item, subTrail);
                            boolean bl = addTrail = !pending.isEmpty();
                        }
                        if (addTrail && (subTrail = TRAILS.get(item)) != null) {
                            trail.add(item);
                            trail.addAll(subTrail);
                        }
                        if (!found.isEmpty()) continue block2;
                    }
                }
                if (found.isEmpty()) continue;
                break;
            }
            result.addAll(found);
        }
        GENERATED.putIfAbsent(targetItem, result);
        TRAILS.putIfAbsent(targetItem, trail);
        return result;
    }

    private static void findAllRecipesForItems(RecipeManager recipeManager) {
        DietConstants.LOG.info("Building item-to-recipes map...");
        RECIPES.clear();
        HashMap<Item, List> result = new HashMap<Item, List>();
        for (Recipe recipe : recipeManager.m_44051_()) {
            ItemStack output = ItemStack.f_41583_;
            try {
                output = recipe.m_8043_();
            }
            catch (Exception e) {
                DietConstants.LOG.error("Diet was unable to process recipe: {}", (Object)recipe.m_6423_());
            }
            if (output == null) {
                DietConstants.LOG.debug("Diet was unable to process recipe due to null output: {}", (Object)recipe.m_6423_());
                continue;
            }
            Item item = output.m_41720_();
            List current = result.computeIfAbsent(item, k -> new ArrayList());
            current.add(recipe);
        }
        for (List list : result.values()) {
            if (list.size() <= 1) continue;
            list.sort(Comparator.comparing(Recipe::m_6423_));
        }
        RECIPES.putAll(result);
        DietConstants.LOG.info("Found {} valid items with recipes", (Object)RECIPES.size());
    }

    private static void findUngroupedFoods(Set<IDietGroup> groups) {
        DietConstants.LOG.info("Finding ungrouped food items...");
        UNGROUPED.clear();
        HashSet<Item> result = new HashSet<Item>();
        block0: for (Item item : Services.REGISTRY.getItems()) {
            ItemStack stack = item.m_7968_();
            FoodProperties food = Services.REGISTRY.getFoodProperties(stack, null);
            if ((food == null || food.m_38744_() <= 0) && !Services.REGISTRY.isSpecialFood(stack)) continue;
            for (IDietGroup group : groups) {
                if (!group.contains(new ItemStack((ItemLike)item))) continue;
                continue block0;
            }
            result.add(item);
        }
        UNGROUPED.addAll(result);
        DietConstants.LOG.info("Found {} ungrouped food items", (Object)UNGROUPED.size());
    }

    public static Map<Item, Set<IDietGroup>> getAll() {
        return ImmutableMap.copyOf(GENERATED);
    }

    public static void load(Map<Item, Set<String>> generated) {
        GENERATED.clear();
        for (Map.Entry<Item, Set<String>> entry : generated.entrySet()) {
            Item item = entry.getKey();
            HashSet groups = new HashSet();
            for (String s : entry.getValue()) {
                DietGroups.CLIENT.getGroup(s).ifPresent(groups::add);
            }
            GENERATED.put(item, groups);
        }
    }

    public static Optional<Set<IDietGroup>> get(Item item) {
        return Optional.ofNullable(GENERATED.get(item));
    }

    public static List<Item> getTrail(Item item) {
        return TRAILS.getOrDefault(item, Collections.emptyList());
    }

    private static class IngredientComparator
    implements Comparator<ItemStack> {
        private IngredientComparator() {
        }

        @Override
        public int compare(ItemStack o1, ItemStack o2) {
            ResourceLocation rl1 = Services.REGISTRY.getItemKey(o1.m_41720_());
            ResourceLocation rl2 = Services.REGISTRY.getItemKey(o2.m_41720_());
            if (rl1 == null) {
                return 1;
            }
            if (rl2 == null) {
                return -1;
            }
            String namespace1 = rl1.m_135827_();
            String namespace2 = rl2.m_135827_();
            if (namespace1.equals("minecraft") && !namespace2.equals("minecraft")) {
                return -1;
            }
            if (namespace2.equals("minecraft") && !namespace1.equals("minecraft")) {
                return 1;
            }
            return rl1.compareTo(rl2);
        }
    }
}

